	function h = PZ_2_IMPULSE_RESPONSE_Z(G, Z, P, n0)

	% Computes the n0 first values of the impulse response from 
	% the poles and zeros of a digital filter.

	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2008-07-03
	% Modified by: 		LW 2011-02-16
	% Copyright:		by authors - not released for commercial use
	% Version: 			
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	% Compute the denominator and numerator of first- and second-order sections 
	% as polynomials, H(z) = (a0*z + a1 + a2*z^-1)/(z - b1 - b2*z^-1)
	
	if mod(length(P),2) == 1
		P = [P;0]; 
	end
	ns = length(P);
	P = cplxpair(P);
	m = 1;
	for n = 1:2:ns
		a1(m) = real(P(n)+P(n+1));
		a2(m) = -real(P(n)*P(n+1));
		m = m+1;
	end
	if mod(length(Z),2) == 1
		Z = [Z;0];
	end
	Z = cplxpair(Z);
	m = 1;
	for n = 1:2:ns
		b0(m) = 1;
		b1(m) = -real(Z(n)+Z(n+1));
		b2(m) = real(Z(n)*Z(n+1));
		m = m+1;
	end
	% Perform the filtering
	u1 = zeros(1,ns/2);
	u2 = zeros(1,ns/2);
	xin = 1;	% Impulse
	y = G*xin;
	for k = 1:n0
		for i = 1:ns/2
			u0 = y + a1(i)*u1(1,i) + a2(i)*u2(1,i);
			y = u0 + b1(i)*u1(1,i) + b2(i)*u2(1,i); 	
			u2(1,i) = u1(1,i);
			u1(1,i) = u0;	
		end
		h(k) = real(y);		% We assume that the impulse response is real
		y = 0;
	end
